<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:param name="lang">en</xsl:param>
<xsl:param name="disablecolor">inactiveborder</xsl:param>
<xsl:param name="page">2</xsl:param>
<xsl:param name="io">in</xsl:param>
<xsl:param name="fvmax">10</xsl:param>
<xsl:template match="/">
<html>
<body>
<xsl:if test="$page != '2'">
	<table width="100%">
		<tr align="center">
			<td>
				<table width="500" border="1">
					<tr>
						<th colspan="3" align="left"><xsl:if test="$lang != 'ja'">User Information</xsl:if><xsl:if test="$lang = 'ja'">ユーザー情報</xsl:if></th>
					</tr>
					<tr>
						<td align="right"><xsl:if test="$lang != 'ja'">User Name</xsl:if><xsl:if test="$lang = 'ja'">ユーザー名</xsl:if></td>
						<td align="left" colspan="2">
							<input type="text" class="ustyle" id="USER" size="54">
								<xsl:attribute name="value">
									<xsl:value-of select="//username"/>
								</xsl:attribute>
							</input>
						</td>
					</tr>
					<tr>
						<td align="right"><xsl:if test="$lang != 'ja'">User E-mail</xsl:if><xsl:if test="$lang = 'ja'">Eメール</xsl:if></td>
						<td align="left" colspan="2">
							<input type="text" class="ustyle" id="EMAIL" size="54">
								<xsl:attribute name="value">
									<xsl:value-of select="//useremail"/>
								</xsl:attribute>
							</input>
						</td>
					</tr>
					<tr>
						<th colspan="3" align="left"><xsl:if test="$lang != 'ja'">Path Setting</xsl:if><xsl:if test="$lang = 'ja'">パス設定</xsl:if></th>
					</tr>
					<tr>
						<td align="right"><xsl:if test="$lang != 'ja'">Parts List Update URL</xsl:if><xsl:if test="$lang = 'ja'">部品表更新URL</xsl:if></td>
						<td align="left" colspan="2">
							<input type="text" class="ustyle" id="UDATE_URL" size="54">
								<xsl:attribute name="value">
									<xsl:value-of select="//updatefolder"/>
								</xsl:attribute>
							</input>
						</td>
					</tr>
					<tr>
						<th colspan="3" align="left"><xsl:if test="$lang != 'ja'">Parts Order Style</xsl:if><xsl:if test="$lang = 'ja'">部品発注スタイル</xsl:if></th>
					</tr>
					<tr class="split">
						<td align="right">
							<input name="poen" type="checkbox" id="JPOST_EN" onclick="setPoEnabled(0, this.id)">
								<xsl:if test="//mailstyle/jpost/@enabled[. = '1']">
									<xsl:attribute name="checked">checked</xsl:attribute>
								</xsl:if>
							</input>
						</td>
						<td align="left" colspan="2">
							J-POST (via E-mail)
						</td>
					</tr>
					<tr class="pstyle_0">
						<xsl:if test="//mailstyle/jpost/@enabled[. != '1']">
							<xsl:attribute name="style">color:<xsl:value-of select="$disablecolor"/></xsl:attribute>
						</xsl:if>
						<td align="right">E-mail to</td>
						<td align="left" colspan="2">
							<input type="text" class="pstyle_0" id="JPOST_EMAIL" size="54">
								<xsl:attribute name="value">
									<xsl:value-of select="//mailstyle/jpost/email"/>
								</xsl:attribute>
								<xsl:if test="//mailstyle/jpost/@enabled[. != '1']">
									<xsl:attribute name="disabled">disabled</xsl:attribute>
								</xsl:if>
							</input>
						</td>
					</tr>
					<tr class="pstyle_0">
						<xsl:if test="//mailstyle/jpost/@enabled[. != '1']">
							<xsl:attribute name="style">color:<xsl:value-of select="$disablecolor"/></xsl:attribute>
						</xsl:if>
						<td align="right">Account Code</td>
						<td align="left" colspan="2">
							<input type="text" class="pstyle_0" id="JPOST_AC" size="54" maxlength="4">
								<xsl:attribute name="value">
									<xsl:value-of select="//mailstyle/jpost/ac"/>
								</xsl:attribute>
								<xsl:if test="//mailstyle/jpost/@enabled[. != '1']">
									<xsl:attribute name="disabled">disabled</xsl:attribute>
								</xsl:if>
							</input>
						</td>
					</tr>
					<tr class="pstyle_0">
						<xsl:if test="//mailstyle/jpost/@enabled[. != '1']">
							<xsl:attribute name="style">color:<xsl:value-of select="$disablecolor"/></xsl:attribute>
						</xsl:if>
						<td align="right">Ship-to</td>
						<td align="left" colspan="2">
							<input type="text" class="pstyle_0" id="JPOST_SP" size="54" maxlength="2">
								<xsl:attribute name="value">
									<xsl:value-of select="//mailstyle/jpost/sp"/>
								</xsl:attribute>
								<xsl:if test="//mailstyle/jpost/@enabled[. != '1']">
									<xsl:attribute name="disabled">disabled</xsl:attribute>
								</xsl:if>
							</input>
						</td>
					</tr>
					<tr class="pstyle_0">
						<xsl:if test="//mailstyle/jpost/@enabled[. != '1']">
							<xsl:attribute name="style">color:<xsl:value-of select="$disablecolor"/></xsl:attribute>
						</xsl:if>
						<td align="right">User ID</td>
						<td align="left" colspan="2">
							<input type="text" class="pstyle_0" id="JPOST_US" size="54" maxlength="10">
								<xsl:attribute name="value">
									<xsl:value-of select="//mailstyle/jpost/us"/>
								</xsl:attribute>
								<xsl:if test="//mailstyle/jpost/@enabled[. != '1']">
									<xsl:attribute name="disabled">disabled</xsl:attribute>
								</xsl:if>
							</input>
						</td>
					</tr>
					<tr class="pstyle_0">
						<xsl:if test="//mailstyle/jpost/@enabled[. != '1']">
							<xsl:attribute name="style">color:<xsl:value-of select="$disablecolor"/></xsl:attribute>
						</xsl:if>
						<td align="right">Password</td>
						<td align="left" colspan="2">
							<input type="password" class="pstyle_0" id="JPOST_PS" size="54" maxlength="10">
								<xsl:attribute name="value">
									<xsl:value-of select="//mailstyle/jpost/ps"/>
								</xsl:attribute>
								<xsl:if test="//mailstyle/jpost/@enabled[. != '1']">
									<xsl:attribute name="disabled">disabled</xsl:attribute>
								</xsl:if>
							</input>
						</td>
					</tr>
					<tr class="split">
						<td align="right">
							<input name="poen" type="checkbox" id="JASPER_EN" onclick="setPoEnabled(1, this.id)">
								<xsl:if test="//mailstyle/jasper/@enabled[. = '1']">
									<xsl:attribute name="checked">checked</xsl:attribute>
								</xsl:if>
							</input>
						</td>
						<td align="left" colspan="2">
							JASPER (via E-mail)
						</td>
					</tr>
					<tr class="pstyle_1">
						<xsl:if test="//mailstyle/jasper/@enabled[. != '1']">
							<xsl:attribute name="style">color:<xsl:value-of select="$disablecolor"/></xsl:attribute>
						</xsl:if>
						<td align="right">E-mail to</td>
						<td align="left" colspan="2">
							<input type="text" class="pstyle_1" id="JASPER_EMAIL" size="54">
								<xsl:attribute name="value">
									<xsl:value-of select="//mailstyle/jasper/email"/>
								</xsl:attribute>
								<xsl:if test="//mailstyle/jasper/@enabled[. != '1']">
									<xsl:attribute name="disabled">disabled</xsl:attribute>
								</xsl:if>
							</input>
						</td>
					</tr>
					<tr class="pstyle_1">
						<xsl:if test="//mailstyle/jasper/@enabled[. != '1']">
							<xsl:attribute name="style">color:<xsl:value-of select="$disablecolor"/></xsl:attribute>
						</xsl:if>
						<td align="right">User ID</td>
						<td align="left" colspan="2">
							<input type="text" class="pstyle_1" id="JASPER_US" size="54" maxlength="10">
								<xsl:attribute name="value">
									<xsl:value-of select="//mailstyle/jasper/us"/>
								</xsl:attribute>
								<xsl:if test="//mailstyle/jasper/@enabled[. != '1']">
									<xsl:attribute name="disabled">disabled</xsl:attribute>
								</xsl:if>
							</input>
						</td>
					</tr>
					<tr class="pstyle_1">
						<xsl:if test="//mailstyle/jasper/@enabled[. != '1']">
							<xsl:attribute name="style">color:<xsl:value-of select="$disablecolor"/></xsl:attribute>
						</xsl:if>
						<td align="right">Password</td>
						<td align="left" colspan="2">
							<input type="password" class="pstyle_1" id="JASPER_PS" size="54" maxlength="10">
								<xsl:attribute name="value">
									<xsl:value-of select="//mailstyle/jasper/ps"/>
								</xsl:attribute>
								<xsl:if test="//mailstyle/jasper/@enabled[. != '1']">
									<xsl:attribute name="disabled">disabled</xsl:attribute>
								</xsl:if>
							</input>
						</td>
					</tr>
					<tr class="split">
						<td align="right">
							<input name="poen" type="checkbox" id="PO_ENABLE" onclick="setPoEnabled(2, this.id)">
								<xsl:if test="//mypartsorder/linkinfo/@enabled[. = '1']">
									<xsl:attribute name="checked">checked</xsl:attribute>
								</xsl:if>
							</input>
						</td>
						<td align="left">
							<xsl:if test="$lang != 'ja'">Web Site Link</xsl:if><xsl:if test="$lang = 'ja'">ウェブサイトリンク</xsl:if>
						</td>
						<td align="right">
							<input type="button" onclick="inputPage('po')">
								<xsl:attribute name="value">
									<xsl:if test="$lang != 'ja'">Input XML</xsl:if><xsl:if test="$lang = 'ja'">XML入力</xsl:if>
								</xsl:attribute>
							</input>
						</td>
					</tr>
					<tr class="pstyle_2">
						<xsl:if test="//mypartsorder/linkinfo/@enabled[. != '1']">
							<xsl:attribute name="style">color:<xsl:value-of select="$disablecolor"/></xsl:attribute>
						</xsl:if>
						<td align="right"><xsl:if test="$lang != 'ja'">Title</xsl:if><xsl:if test="$lang = 'ja'">タイトル</xsl:if></td>
						<td align="left" colspan="2">
							<input type="text" class="pstyle_2" id="PO_NAME" size="54">
								<xsl:attribute name="value">
									<xsl:value-of select="//mypartsorder/linkinfo/@title"/>
								</xsl:attribute>
								<xsl:if test="//mypartsorder/linkinfo/@enabled[. != '1']">
									<xsl:attribute name="disabled">disabled</xsl:attribute>
								</xsl:if>
							</input>
						</td>
					</tr>
					<tr class="pstyle_2">
						<xsl:if test="//mypartsorder/linkinfo/@enabled[. != '1']">
							<xsl:attribute name="style">color:<xsl:value-of select="$disablecolor"/></xsl:attribute>
						</xsl:if>
						<td align="right">URL</td>
						<td align="left" colspan="2">
							<input type="text" class="pstyle_2" id="PO_URL" size="54">
								<xsl:attribute name="value">
									<xsl:value-of select="//mypartsorder/linkinfo/url"/>
								</xsl:attribute>
								<xsl:if test="//mypartsorder/linkinfo/@enabled[. != '1']">
									<xsl:attribute name="disabled">disabled</xsl:attribute>
								</xsl:if>
							</input>
						</td>
					</tr>
					<tr class="pstyle_2">
						<xsl:if test="//mypartsorder/linkinfo/@enabled[. != '1']">
							<xsl:attribute name="style">color:<xsl:value-of select="$disablecolor"/></xsl:attribute>
						</xsl:if>
						<td align="right">Submit</td>
						<td align="left" colspan="2">
							<input type="text" class="pstyle_2" id="PO_SUBMIT" size="54">
								<xsl:attribute name="value">
									<xsl:value-of select="//mypartsorder/linkinfo/submit"/>
								</xsl:attribute>
								<xsl:if test="//mypartsorder/linkinfo/@enabled[. != '1']">
									<xsl:attribute name="disabled">disabled</xsl:attribute>
								</xsl:if>
							</input>
						</td>
					</tr>
					<tr class="pstyle_2">
						<xsl:if test="//mypartsorder/linkinfo/@enabled[. != '1']">
							<xsl:attribute name="style">color:<xsl:value-of select="$disablecolor"/></xsl:attribute>
						</xsl:if>
						<td align="right">Method</td>
						<td align="left" colspan="2">
							<input name="PO_METHOD" type="radio" class="pstyle_2" value="0" onclick="setPoMethod(this.value)">
								<xsl:if test="//mypartsorder/linkinfo/method/@id[. = '0']">
									<xsl:attribute name="checked">checked</xsl:attribute>
								</xsl:if>
								<xsl:if test="//mypartsorder/linkinfo/@enabled[. != '1']">
									<xsl:attribute name="disabled">disabled</xsl:attribute>
								</xsl:if>
							</input>
							none
							<input name="PO_METHOD" type="radio" class="pstyle_2" value="1" onclick="setPoMethod(this.value)">
								<xsl:if test="//mypartsorder/linkinfo/method/@id[. = '1']">
									<xsl:attribute name="checked">checked</xsl:attribute>
								</xsl:if>
								<xsl:if test="//mypartsorder/linkinfo/@enabled[. != '1']">
									<xsl:attribute name="disabled">disabled</xsl:attribute>
								</xsl:if>
							</input>
							get
							<input name="PO_METHOD" type="radio" class="pstyle_2" value="2" onclick="setPoMethod(this.value)">
								<xsl:if test="//mypartsorder/linkinfo/method/@id[. = '2']">
									<xsl:attribute name="checked">checked</xsl:attribute>
								</xsl:if>
								<xsl:if test="//mypartsorder/linkinfo/@enabled[. != '1']">
									<xsl:attribute name="disabled">disabled</xsl:attribute>
								</xsl:if>
							</input>
							post
						</td>
					</tr>
					<tr class="pstyle_2">
						<xsl:if test="//mypartsorder/linkinfo/@enabled[. != '1']">
							<xsl:attribute name="style">color:<xsl:value-of select="$disablecolor"/></xsl:attribute>
						</xsl:if>
						<td align="right">ID</td>
						<td align="left" colspan="2">
							<input type="text" class="pstyle_2" id="PO_ID" size="54">
								<xsl:attribute name="value">
									<xsl:value-of select="//mypartsorder/linkinfo/userid"/>
								</xsl:attribute>
								<xsl:if test="//mypartsorder/linkinfo/@enabled[. != '1']">
									<xsl:attribute name="disabled">disabled</xsl:attribute>
								</xsl:if>
							</input>
						</td>
					</tr>
					<tr class="pstyle_2">
						<xsl:if test="//mypartsorder/linkinfo/@enabled[. != '1']">
							<xsl:attribute name="style">color:<xsl:value-of select="$disablecolor"/></xsl:attribute>
						</xsl:if>
						<td align="right"><xsl:if test="$lang != 'ja'">Password</xsl:if><xsl:if test="$lang = 'ja'">パスワード</xsl:if></td>
						<td align="left" colspan="2">
							<input type="password" class="pstyle_2" id="PO_PWD" size="54">
								<xsl:attribute name="value">
									<xsl:value-of select="//mypartsorder/linkinfo/userpsswrd"/>
								</xsl:attribute>
								<xsl:if test="//mypartsorder/linkinfo/@enabled[. != '1']">
									<xsl:attribute name="disabled">disabled</xsl:attribute>
								</xsl:if>
							</input>
						</td>
					</tr>
					<tr>
						<th colspan="2" align="left"><xsl:if test="$lang != 'ja'">My Favorite</xsl:if><xsl:if test="$lang = 'ja'">お気に入りリンク設定</xsl:if></th>
						<th align="right">
							<input type="button" style="font-weight:normal" onclick="inputPage('fv')">
								<xsl:attribute name="value">
									<xsl:if test="$lang != 'ja'">Input XML</xsl:if><xsl:if test="$lang = 'ja'">XML入力</xsl:if>
								</xsl:attribute>
							</input>
						</th>
					</tr>
					<xsl:apply-templates select="//myfavorite/linkinfo"/>
				</table>
				<br />
				<input type="button" id="btnSave" onClick="saveSetup();window.close();">
					<xsl:attribute name="value">
						<xsl:if test="$lang != 'ja'">Save</xsl:if><xsl:if test="$lang = 'ja'">設定保存</xsl:if>
					</xsl:attribute>
				</input>
				<input type="button" id="btnReset" onClick="resetSetup();">
					<xsl:attribute name="value">
						<xsl:if test="$lang != 'ja'">Reset</xsl:if><xsl:if test="$lang = 'ja'">リセット</xsl:if>
					</xsl:attribute>
				</input>
				<input type="button" id="btnOutput" onClick="outputPage();">
					<xsl:attribute name="value">
						<xsl:if test="$lang != 'ja'">Output XML</xsl:if><xsl:if test="$lang = 'ja'">XML出力</xsl:if>
					</xsl:attribute>
				</input>
				<input type="button" id="btnInput" onClick="inputPage('all');">
					<xsl:attribute name="value">
						<xsl:if test="$lang != 'ja'">Input XML</xsl:if><xsl:if test="$lang = 'ja'">XML入力</xsl:if>
					</xsl:attribute>
				</input>
				<input type="button" id="btnCancel" onClick="window.close();">
					<xsl:attribute name="value">
						<xsl:if test="$lang != 'ja'">Cancel</xsl:if><xsl:if test="$lang = 'ja'">キャンセル</xsl:if>
					</xsl:attribute>
				</input>
			</td>
		</tr>
	</table>
</xsl:if>
<xsl:if test="$page = '2'">
	<table width="100%">
		<tr align="center">
			<td>
				<table width="500">
					<tr>
						<xsl:if test="$io = 'out'">
							<th align="left"><xsl:if test="$lang != 'ja'">Output XML</xsl:if><xsl:if test="$lang = 'ja'">XML出力</xsl:if></th>
						</xsl:if>
						<xsl:if test="$io = 'in'">
							<th align="left"><xsl:if test="$lang != 'ja'">Input XML</xsl:if><xsl:if test="$lang = 'ja'">XML入力</xsl:if></th>
						</xsl:if>
					</tr>
					<tr>
						<td>
							<textarea name="textarea" cols="60" rows="30" wrap="off" id="textarea">
								<xsl:if test="$io = 'out'">
									<xsl:attribute name="readonly">readonly</xsl:attribute>
								</xsl:if>
							</textarea>
						</td>
					</tr>
				</table>
				<br />
				<xsl:if test="$io = 'in'">
					<input type="button" id="btnApply" onClick="applyText();">
						<xsl:attribute name="value">
							<xsl:if test="$lang != 'ja'">Apply</xsl:if><xsl:if test="$lang = 'ja'">適用</xsl:if>
						</xsl:attribute>
					</input>
				</xsl:if>
				<input type="button" id="btnBack" onClick="backPage();">
					<xsl:attribute name="value">
						<xsl:if test="$lang != 'ja'">Back</xsl:if><xsl:if test="$lang = 'ja'">戻る</xsl:if>
					</xsl:attribute>
				</input>
			</td>
		</tr>
	</table>
</xsl:if>
</body>
</html>
</xsl:template>

<xsl:template match="//myfavorite/linkinfo">
	<tr class="split">
		<td align="right">
			<xsl:if test="$lang != 'ja'">Setting-<xsl:value-of select="position()"/></xsl:if><xsl:if test="$lang = 'ja'">設定-<xsl:value-of select="position()"/></xsl:if>
		</td>
		<td align="left">
			<input type="button">
				<xsl:attribute name="value">
					<xsl:if test="$lang != 'ja'">&#9650;Up</xsl:if><xsl:if test="$lang = 'ja'">&#9650;上へ</xsl:if>
				</xsl:attribute>
				<xsl:if test="position() = 1">
					<xsl:attribute name="disabled">
						disabled
					</xsl:attribute>
				</xsl:if>
				<xsl:attribute name="onclick">
					apply();upItem('<xsl:value-of select="position()"/>')
				</xsl:attribute>
			</input>
			<input type="button">
				<xsl:attribute name="value">
					<xsl:if test="$lang != 'ja'">&#9660;Down</xsl:if><xsl:if test="$lang = 'ja'">&#9660;下へ</xsl:if>
				</xsl:attribute>
				<xsl:if test="position() = last()">
					<xsl:attribute name="disabled">
						disabled
					</xsl:attribute>
				</xsl:if>
				<xsl:attribute name="onclick">
					apply();downItem('<xsl:value-of select="position()"/>')
				</xsl:attribute>
			</input>
		</td>
		<td align="right">
			<xsl:if test="position() = last()">
				<input type="button">
					<xsl:attribute name="value">
						<xsl:if test="$lang != 'ja'">&#9660;Add</xsl:if><xsl:if test="$lang = 'ja'">&#9660;追加</xsl:if>
					</xsl:attribute>
					<xsl:attribute name="onclick">
						apply();addItem('<xsl:value-of select="last()"/>')
					</xsl:attribute>
					<xsl:if test="position() &gt; ($fvmax - 1)">
						<xsl:attribute name="disabled">
							disabled
						</xsl:attribute>
					</xsl:if>
				</input>
			</xsl:if>
			<xsl:if test="last() = 1">
				<input type="button">
					<xsl:attribute name="value">
						<xsl:if test="$lang != 'ja'">Clear</xsl:if><xsl:if test="$lang = 'ja'">クリア</xsl:if>
					</xsl:attribute>
					<xsl:attribute name="onclick">
						clearItem('<xsl:value-of select="position()"/>');apply()
					</xsl:attribute>
				</input>
			</xsl:if>
			<xsl:if test="last() &gt; 1">
				<input type="button">
					<xsl:attribute name="value">
						<xsl:if test="$lang != 'ja'">Delete</xsl:if><xsl:if test="$lang = 'ja'">削除</xsl:if>
					</xsl:attribute>
					<xsl:attribute name="onclick">
						apply();deleteItem('<xsl:value-of select="position()"/>')
					</xsl:attribute>
				</input>
			</xsl:if>
		</td>
	</tr>
	<tr>
		<td align="right"><xsl:if test="$lang != 'ja'">Title</xsl:if><xsl:if test="$lang = 'ja'">タイトル</xsl:if></td>
		<td align="left" colspan="2">
			<input type="text" class="fstyle" size="54">
				<xsl:attribute name="id">web_<xsl:value-of select="position()"/>_1</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="@title"/>
				</xsl:attribute>
			</input>
		</td>
	</tr>
	<tr>
		<td align="right">URL</td>
		<td align="left" colspan="2">
			<input type="text" class="fstyle" size="54">
				<xsl:attribute name="id">web_<xsl:value-of select="position()"/>_2</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="url"/>
				</xsl:attribute>
			</input>
		</td>
	</tr>
	<tr>
		<td align="right">Submit</td>
		<td align="left" colspan="2">
			<input type="text" class="fstyle" size="54">
				<xsl:attribute name="id">web_<xsl:value-of select="position()"/>_3</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="submit"/>
				</xsl:attribute>
			</input>
		</td>
	</tr>
	<tr>
		<td align="right">Method</td>
		<td align="left" colspan="2">
			<input type="radio" class="fstyle" value="0">
				<xsl:attribute name="onclick">
					setFvMethod(<xsl:value-of select="position()"/>, this.value)
				</xsl:attribute>
				<xsl:attribute name="name">web_<xsl:value-of select="position()"/>_4</xsl:attribute>
				<xsl:if test="method/@id[. = '0']">
					<xsl:attribute name="checked">checked</xsl:attribute>
				</xsl:if>
			</input>
			none
			<input type="radio" class="fstyle" value="1">
				<xsl:attribute name="onclick">
					setFvMethod(<xsl:value-of select="position()"/>, this.value)
				</xsl:attribute>
				<xsl:attribute name="name">web_<xsl:value-of select="position()"/>_4</xsl:attribute>
				<xsl:if test="method/@id[. = '1']">
					<xsl:attribute name="checked">checked</xsl:attribute>
				</xsl:if>
			</input>
			get
			<input type="radio" class="fstyle" value="2">
				<xsl:attribute name="onclick">
					setFvMethod(<xsl:value-of select="position()"/>, this.value)
				</xsl:attribute>
				<xsl:attribute name="name">web_<xsl:value-of select="position()"/>_4</xsl:attribute>
				<xsl:if test="method/@id[. = '2']">
					<xsl:attribute name="checked">checked</xsl:attribute>
				</xsl:if>
			</input>
			post</td>
	</tr>
	<tr>
		<td align="right">ID</td>
		<td align="left" colspan="2">
			<input type="text" class="fstyle" size="54">
				<xsl:attribute name="id">web_<xsl:value-of select="position()"/>_5</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="userid"/>
				</xsl:attribute>
			</input>
		</td>
	</tr>
	<tr>
		<td align="right"><xsl:if test="$lang != 'ja'">Password</xsl:if><xsl:if test="$lang = 'ja'">パスワード</xsl:if></td>
		<td align="left" colspan="2">
			<input type="password" class="fstyle" size="54">
				<xsl:attribute name="id">web_<xsl:value-of select="position()"/>_6</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="userpsswrd"/>
				</xsl:attribute>
			</input>
		</td>
	</tr>
</xsl:template>

</xsl:stylesheet>
